CREATE OR REPLACE FUNCTION tlog.Auditlog__references__get(
      _tabname                  varchar,
      _parent_id                varchar = '',
      _old                      varchar = '',

      OUT references_tablename  varchar,
      OUT references_FName      varchar,
      OUT references_id         varchar
  ) RETURNS record AS $$
  BEGIN
    CASE _tabname
        WHEN 'ab2ba' THEN
            references_tablename := 'ab2';
            references_FName     := 'a2_id';
            references_id        := ( SELECT a2ba_a2_id FROM ab2ba WHERE a2ba_id = _parent_id );
       
            --REGEX MARKEND--
        WHEN 'artcodlang' THEN
            references_tablename := 'artcod';
            references_FName     := 'ac_n';
            references_id        := _parent_id;
       
            --REGEX MARKEND--
        WHEN 'artpruefungtest' THEN
            references_tablename := 'ldsdok';
            references_FName     := 'ld_id';
            references_id        := ( SELECT aprt_ldid FROM artpruefungtest WHERE aprt_id = _parent_id );
       
            --REGEX MARKEND--
        WHEN 'beleg_p__artchange' THEN
             references_tablename := 'tartikel.beleg_k__artchange';
             references_FName     := 'p_k_id';

            IF _old = '' THEN
                   references_id    := ( SELECT p_id FROM tartikel.beleg_p__artchange WHERE p_id = _parent_id );
            ELSE
                   references_id    := _old;
            END IF;
       
            --REGEX MARKEND--
        WHEN 'epreisabzu' THEN
            references_tablename := 'epreis';
            references_FName     := 'e_aknr';
            references_id        := ( SELECT e_aknr FROM epreis WHERE e_id = _parent_id );
       
            --REGEX MARKEND--
        WHEN 'recnokeyword' THEN
            references_tablename := 'tartikel.beleg_k__artchange';
            references_FName     := 'k_id';

            IF ( isnumeric(_parent_id) ) THEN
                references_id    := k_id FROM tartikel.beleg_k__artchange WHERE dbrid = (SELECT r_dbrid FROM recnokeyword WHERE r_id = _parent_id::int);
            ELSE
                RAISE WARNING '%', format('tlog.Auditlog__references__get(%L,%L,%L)', _tabname, _parent_id, _old);
            END IF;
        
            --REGEX MARKEND--
        ELSE
            references_tablename := null;
            references_FName     := null;
            references_id        := null;
    END CASE;
    RETURN;
  END $$ LANGUAGE plpgsql STABLE;
